CREATE FUNCTION dbo.F_VALIDATION_NOM_SQL(@NOM_SQL sysname)
   RETURNS BIT
   WITH RETURNS NULL ON NULL INPUT
AS
-- Vrifie la validit dun nom dobjet conforme  la norme SQL
BEGIN
   DECLARE @I TINYINT = 1, @NC CHAR(1);
   WHILE @I <= LEN(@NOM_SQL)
   BEGIN
-- Pas dautres caractres que [A..Z] U [0..1] U [ _ ]
      SET @NC = SUBSTRING(@NOM_SQL, @I, 1);
      IF @NC NOT BETWEEN 'A' AND 'Z'
         AND @NC NOT BETWEEN '0' AND '9'
         AND @NC <> '_'
         RETURN 0;
-- Pas de nombre en premier caractre
      IF @I = 1 AND @NC BETWEEN '0' AND '9'
         RETURN 0;
      SET @I = @I + 1;
   END
   RETURN 1
END;
GO

CREATE FUNCTION dbo.F_TRIGRAMME_UNIQUE(@NOM_SQL sysname,
                                       @TYPE_OBJET CHAR(10))
   RETURNS BIT
   WITH RETURNS NULL ON NULL INPUT
AS
-- Vrifie lunicit du trigramme dans la catgorie de lobjet
BEGIN
   IF @TYPE_OBJET NOT IN ('TABLE', 'VIEW', 'PROCEDURE', 'FUNCTION', 'TRIGGER')
      RETURN 0;
-- Sil existe dj un tel trigramme (sauf celui de lobjet lui-mme)
-- et pour la catgorie dobjet vis, alors retourner 0
   IF EXISTS(SELECT *
             FROM   sys.objects AS o
             WHERE  RIGHT(name, 3) = RIGHT(@NOM_SQL, 3)
               AND  name <> @NOM_SQL
               AND  CASE WHEN @TYPE_OBJET = 'TABLE' AND type = 'U' 
			                THEN 1
                         WHEN @TYPE_OBJET = 'VIEW' AND type = 'V' 
						    THEN 1
                         WHEN @TYPE_OBJET = 'TRIGGER' AND type IN ('CLR_TRIGGER', 'SQL_TRIGGER') 
						    THEN 1
                         WHEN @TYPE_OBJET = 'PROCEDURE' AND type IN ('CLR_STORED_PROCEDURE', 'SQL_STORED_PROCEDURE') 
						    THEN 1
                         WHEN @TYPE_OBJET = 'FUNCTION' AND type IN ('CLR_SCALAR_FUNCTION', 'CLR_TABLE_VALUED_FUNCTION', 'SQL_INLINE_TABLE_VALUED_FUNCTION', 'SQL_SCALAR_FUNCTION', 'SQL_TABLE_VALUED_FUNCTION') 
						    THEN 1
                    END = 1)
      RETURN 0
   RETURN 1
END;
GO